VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{16E688B9-621D-4724-B36C-345517BA75B5}#117.0#0"; "VRMIXER.OCX"
Begin VB.Form frmVRMixerSample 
   Caption         =   "VR Mixer Sample"
   ClientHeight    =   6180
   ClientLeft      =   2595
   ClientTop       =   1680
   ClientWidth     =   6825
   LinkTopic       =   "Form1"
   ScaleHeight     =   6180
   ScaleWidth      =   6825
   Begin VB.Frame fraPlayback 
      Caption         =   "Playback"
      Height          =   5484
      Left            =   3528
      TabIndex        =   12
      Top             =   108
      Width           =   3180
      Begin VB.Frame Frame4 
         Caption         =   "Peak Meter           "
         Height          =   1092
         Left            =   144
         TabIndex        =   47
         Top             =   4284
         Width           =   2928
         Begin VB.CommandButton cmdPlay 
            Caption         =   ">"
            Enabled         =   0   'False
            BeginProperty Font 
               Name            =   "Fixedsys"
               Size            =   9
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   300
            Left            =   144
            TabIndex        =   51
            ToolTipText     =   "Play"
            Top             =   288
            Width           =   336
         End
         Begin VB.CheckBox chkPlayPeakmeter 
            Alignment       =   1  'Right Justify
            Enabled         =   0   'False
            Height          =   264
            Left            =   1044
            TabIndex        =   48
            Top             =   0
            Width           =   228
         End
         Begin ComctlLib.ProgressBar pbPlayPeakmeter 
            Height          =   192
            Left            =   108
            TabIndex        =   49
            Top             =   720
            Width           =   2676
            _ExtentX        =   4736
            _ExtentY        =   344
            _Version        =   327682
            Appearance      =   1
         End
         Begin ComctlLib.Slider sldPlayMeterInterval 
            Height          =   264
            Left            =   1980
            TabIndex        =   52
            ToolTipText     =   "Meter Interval"
            Top             =   288
            Width           =   804
            _ExtentX        =   1429
            _ExtentY        =   476
            _Version        =   327682
            LargeChange     =   40
            SmallChange     =   20
            Max             =   200
            TickStyle       =   1
            TickFrequency   =   20
         End
         Begin VB.Label lblPlayMeterInterval 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   264
            Left            =   1620
            TabIndex        =   53
            Top             =   288
            Width           =   336
         End
      End
      Begin VB.Frame fraMasterOut 
         Height          =   3720
         Left            =   144
         TabIndex        =   22
         Top             =   504
         Width           =   1395
         Begin VB.CheckBox chkMasterMute 
            Caption         =   "Mute All"
            Height          =   195
            Left            =   252
            TabIndex        =   23
            Top             =   3072
            Width           =   865
         End
         Begin ComctlLib.Slider sldMasterVolume 
            Height          =   1668
            Left            =   540
            TabIndex        =   24
            Top             =   1260
            Width           =   636
            _ExtentX        =   1111
            _ExtentY        =   2937
            _Version        =   327682
            Orientation     =   1
            LargeChange     =   10
            Max             =   100
            TickStyle       =   2
            TickFrequency   =   10
         End
         Begin VB.Label lblCurMasterVolume 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            Caption         =   "     "
            Height          =   192
            Left            =   720
            TabIndex        =   29
            Top             =   1080
            Width           =   204
         End
         Begin VB.Label lblMinVolume 
            Alignment       =   2  'Center
            Caption         =   "0"
            Height          =   264
            Index           =   0
            Left            =   144
            TabIndex        =   28
            Top             =   2664
            Width           =   372
         End
         Begin VB.Label lblMaxVolume 
            Alignment       =   2  'Center
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            BackStyle       =   0  'Transparent
            Caption         =   "100"
            ForeColor       =   &H80000008&
            Height          =   264
            Index           =   0
            Left            =   108
            TabIndex        =   27
            Top             =   1332
            Width           =   372
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000014&
            Index           =   0
            X1              =   180
            X2              =   1248
            Y1              =   696
            Y2              =   696
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000010&
            Index           =   1
            X1              =   180
            X2              =   1212
            Y1              =   684
            Y2              =   684
         End
         Begin VB.Label lblMasterOut 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Master Out"
            Height          =   192
            Left            =   180
            LinkTimeout     =   0
            TabIndex        =   26
            Top             =   288
            Width           =   768
         End
         Begin VB.Label lblVolume 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Volume"
            Height          =   192
            Index           =   0
            Left            =   396
            LinkTimeout     =   0
            TabIndex        =   25
            Top             =   864
            Width           =   552
         End
         Begin VB.Image imgSpkrLeft 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   0
            Left            =   36
            Picture         =   "VRMixer Sample.frx":0000
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Image imgSpkrRight 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   0
            Left            =   1080
            Picture         =   "VRMixer Sample.frx":044A
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
      End
      Begin VB.Frame Frame1 
         Height          =   3720
         Left            =   1656
         TabIndex        =   14
         Top             =   504
         Width           =   1395
         Begin VB.CheckBox chkPlaySelect 
            Caption         =   "Select"
            Height          =   195
            Left            =   252
            TabIndex        =   31
            Top             =   3348
            Width           =   865
         End
         Begin VB.CheckBox chkPlayMute 
            Caption         =   "Mute"
            Height          =   195
            Left            =   252
            TabIndex        =   15
            Top             =   3072
            Width           =   865
         End
         Begin ComctlLib.Slider sldPlayVolume 
            Height          =   1668
            Left            =   540
            TabIndex        =   16
            Top             =   1260
            Width           =   636
            _ExtentX        =   1111
            _ExtentY        =   2937
            _Version        =   327682
            Orientation     =   1
            LargeChange     =   10
            Max             =   100
            TickStyle       =   2
            TickFrequency   =   10
         End
         Begin VB.Image imgSpkrRight 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   1
            Left            =   1080
            Picture         =   "VRMixer Sample.frx":0894
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Image imgSpkrLeft 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   1
            Left            =   36
            Picture         =   "VRMixer Sample.frx":0CDE
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Label lblVolume 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Volume"
            Height          =   192
            Index           =   1
            Left            =   432
            LinkTimeout     =   0
            TabIndex        =   21
            Top             =   864
            Width           =   552
         End
         Begin VB.Label lblPlaybackSource 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Playback Source"
            Height          =   408
            Left            =   180
            LinkTimeout     =   0
            TabIndex        =   20
            Top             =   252
            Width           =   1092
            WordWrap        =   -1  'True
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000010&
            Index           =   2
            X1              =   180
            X2              =   1212
            Y1              =   684
            Y2              =   684
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000014&
            Index           =   3
            X1              =   180
            X2              =   1248
            Y1              =   696
            Y2              =   696
         End
         Begin VB.Label lblMaxVolume 
            Alignment       =   2  'Center
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            BackStyle       =   0  'Transparent
            Caption         =   "100"
            ForeColor       =   &H80000008&
            Height          =   264
            Index           =   1
            Left            =   108
            TabIndex        =   19
            Top             =   1332
            Width           =   372
         End
         Begin VB.Label lblMinVolume 
            Alignment       =   2  'Center
            Caption         =   "0"
            Height          =   264
            Index           =   1
            Left            =   144
            TabIndex        =   18
            Top             =   2664
            Width           =   372
         End
         Begin VB.Label lblCurPlayVolume 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            Caption         =   "     "
            Height          =   192
            Left            =   720
            TabIndex        =   17
            Top             =   1080
            Width           =   204
         End
      End
      Begin VB.ComboBox cboPlaySrcType 
         Height          =   288
         Left            =   1620
         Style           =   2  'Dropdown List
         TabIndex        =   13
         Top             =   216
         Width           =   1416
      End
   End
   Begin VB.Frame fraRecording 
      Caption         =   "Recording"
      Height          =   5484
      Left            =   144
      TabIndex        =   3
      Top             =   108
      Width           =   3180
      Begin VB.Frame fraRecMeter 
         Caption         =   "Peak Meter           "
         Height          =   1092
         Left            =   144
         TabIndex        =   42
         Top             =   4284
         Width           =   2928
         Begin VB.CommandButton cmdRecord 
            Caption         =   "o"
            BeginProperty Font 
               Name            =   "Fixedsys"
               Size            =   9
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   312
            Left            =   180
            TabIndex        =   50
            ToolTipText     =   "Start Recording from Microphone"
            Top             =   288
            Width           =   336
         End
         Begin VB.CheckBox chkRecPeakmeter 
            Alignment       =   1  'Right Justify
            Enabled         =   0   'False
            Height          =   264
            Left            =   1044
            TabIndex        =   43
            Top             =   0
            Width           =   228
         End
         Begin ComctlLib.ProgressBar pbRecPeakmeter 
            Height          =   192
            Left            =   144
            TabIndex        =   44
            Top             =   720
            Width           =   2676
            _ExtentX        =   4710
            _ExtentY        =   344
            _Version        =   327682
            Appearance      =   1
         End
         Begin ComctlLib.Slider sldRecMeterInterval 
            Height          =   264
            Left            =   2052
            TabIndex        =   45
            ToolTipText     =   "Meter Interval"
            Top             =   216
            Width           =   804
            _ExtentX        =   1402
            _ExtentY        =   476
            _Version        =   327682
            LargeChange     =   40
            SmallChange     =   20
            Max             =   200
            TickStyle       =   1
            TickFrequency   =   20
         End
         Begin VB.Label lblRecMeterInterval 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   264
            Left            =   1692
            TabIndex        =   46
            Top             =   252
            Width           =   336
         End
      End
      Begin VB.Frame Frame3 
         Height          =   3720
         Left            =   144
         TabIndex        =   33
         Top             =   504
         Width           =   1395
         Begin VB.CheckBox chkRecMasterMute 
            Caption         =   "Mute All"
            Height          =   195
            Left            =   252
            TabIndex        =   34
            Top             =   3072
            Width           =   865
         End
         Begin ComctlLib.Slider sldRecMasterVolume 
            Height          =   1668
            Left            =   540
            TabIndex        =   35
            Top             =   1260
            Width           =   636
            _ExtentX        =   1111
            _ExtentY        =   2937
            _Version        =   327682
            Orientation     =   1
            LargeChange     =   10
            Max             =   100
            TickStyle       =   2
            TickFrequency   =   10
         End
         Begin VB.Image imgSpkrRight 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   3
            Left            =   1080
            Picture         =   "VRMixer Sample.frx":1128
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Image imgSpkrLeft 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   3
            Left            =   36
            Picture         =   "VRMixer Sample.frx":1572
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Label lblVolume 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Volume"
            Height          =   192
            Index           =   3
            Left            =   396
            LinkTimeout     =   0
            TabIndex        =   41
            Top             =   864
            Width           =   552
         End
         Begin VB.Label Label3 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Master In"
            Height          =   192
            Left            =   216
            LinkTimeout     =   0
            TabIndex        =   39
            Top             =   288
            Width           =   648
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000010&
            Index           =   7
            X1              =   180
            X2              =   1212
            Y1              =   684
            Y2              =   684
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000014&
            Index           =   6
            X1              =   180
            X2              =   1248
            Y1              =   696
            Y2              =   696
         End
         Begin VB.Label lblMaxVolume 
            Alignment       =   2  'Center
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            BackStyle       =   0  'Transparent
            Caption         =   "100"
            ForeColor       =   &H80000008&
            Height          =   264
            Index           =   3
            Left            =   108
            TabIndex        =   38
            Top             =   1332
            Width           =   372
         End
         Begin VB.Label lblMinVolume 
            Alignment       =   2  'Center
            Caption         =   "0"
            Height          =   264
            Index           =   3
            Left            =   144
            TabIndex        =   37
            Top             =   2664
            Width           =   372
         End
         Begin VB.Label lblCurRecMasterVolume 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            Caption         =   "     "
            Height          =   192
            Left            =   720
            TabIndex        =   36
            Top             =   1080
            Width           =   204
         End
      End
      Begin VB.Frame Frame2 
         Height          =   3720
         Left            =   1656
         TabIndex        =   5
         Top             =   504
         Width           =   1395
         Begin VB.CheckBox chkRecSelect 
            Caption         =   "Select"
            Height          =   195
            Left            =   252
            TabIndex        =   32
            Top             =   3348
            Width           =   865
         End
         Begin VB.CheckBox chkRecMute 
            Caption         =   "Mute"
            Height          =   195
            Left            =   252
            TabIndex        =   6
            Top             =   3072
            Width           =   865
         End
         Begin ComctlLib.Slider sldRecVolume 
            Height          =   1668
            Left            =   540
            TabIndex        =   7
            Top             =   1260
            Width           =   636
            _ExtentX        =   1111
            _ExtentY        =   2937
            _Version        =   327682
            Orientation     =   1
            LargeChange     =   10
            Max             =   100
            TickStyle       =   2
            TickFrequency   =   10
         End
         Begin VB.Image imgSpkrRight 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   2
            Left            =   1080
            Picture         =   "VRMixer Sample.frx":19BC
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Image imgSpkrLeft 
            Appearance      =   0  'Flat
            Height          =   276
            Index           =   2
            Left            =   36
            Picture         =   "VRMixer Sample.frx":1E06
            Stretch         =   -1  'True
            Top             =   828
            Width           =   276
         End
         Begin VB.Label lblVolume 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Volume"
            Height          =   192
            Index           =   2
            Left            =   396
            LinkTimeout     =   0
            TabIndex        =   40
            Top             =   864
            Width           =   552
         End
         Begin VB.Label lblCurRecVolume 
            Alignment       =   2  'Center
            AutoSize        =   -1  'True
            Caption         =   "     "
            Height          =   192
            Left            =   720
            TabIndex        =   11
            Top             =   1080
            Width           =   204
         End
         Begin VB.Label lblMinVolume 
            Alignment       =   2  'Center
            Caption         =   "0"
            Height          =   264
            Index           =   2
            Left            =   144
            TabIndex        =   10
            Top             =   2664
            Width           =   372
         End
         Begin VB.Label lblMaxVolume 
            Alignment       =   2  'Center
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            BackStyle       =   0  'Transparent
            Caption         =   "100"
            ForeColor       =   &H80000008&
            Height          =   264
            Index           =   2
            Left            =   108
            TabIndex        =   9
            Top             =   1332
            Width           =   372
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000014&
            Index           =   4
            X1              =   180
            X2              =   1248
            Y1              =   696
            Y2              =   696
         End
         Begin VB.Line Line1 
            BorderColor     =   &H80000010&
            Index           =   5
            X1              =   180
            X2              =   1212
            Y1              =   684
            Y2              =   684
         End
         Begin VB.Label lblRecordingSource 
            Appearance      =   0  'Flat
            AutoSize        =   -1  'True
            Caption         =   "Recording Source"
            Height          =   408
            Left            =   180
            LinkTimeout     =   0
            TabIndex        =   8
            Top             =   252
            Width           =   1092
            WordWrap        =   -1  'True
         End
      End
      Begin VB.ComboBox cboRecSrcType 
         Height          =   288
         Left            =   1620
         Style           =   2  'Dropdown List
         TabIndex        =   4
         Top             =   216
         Width           =   1416
      End
   End
   Begin VB.CheckBox chkRetainValues 
      Caption         =   " Retain Values"
      Height          =   336
      Left            =   3528
      TabIndex        =   2
      Top             =   5724
      Width           =   1344
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   372
      Left            =   5796
      TabIndex        =   1
      Top             =   5724
      Width           =   768
   End
   Begin VB.CheckBox chkFullDuplex 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   228
      Left            =   1080
      TabIndex        =   0
      Top             =   5724
      Width           =   228
   End
   Begin VB.Timer tmrRecord 
      Left            =   6660
      Top             =   5364
   End
   Begin VRMixerOCX.VRMixer VRMixer1 
      Left            =   2640
      Top             =   5400
      _ExtentX        =   1614
      _ExtentY        =   1614
      RecMute         =   -1
      PlaySourceName  =   "Wave                            "
      PlayVolume      =   57
      RecSourceName   =   "Microphone                      "
      RecVolume       =   56
      PlayMasterVolume=   76
      RecMasterVolume =   -1
      RecMasterMute   =   -1
      RecSelect       =   1
      PlaySelect      =   -1
      PlayPeakmeterValue=   -1
      PlayPeakmeterInterval=   -1
      RecPeakmeterValue=   -1
      RecPeakmeterInterval=   -1
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Full Duplex :"
      Height          =   192
      Left            =   144
      TabIndex        =   30
      Top             =   5724
      Width           =   864
   End
End
Attribute VB_Name = "frmVRMixerSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'VR Mixer ActiveX Sample application (Copyright SoftVR TM, VRSolution TM, 2002)
'You are free to use the application (modified or not) in any commercial or
'non-commercial product provided you legally aquired and use VRMixer ActiveX
'according to the licence agreement.

Private Enum SrcLnType
  srcUndefined = 0
  srcLine = 1
  srcMicrophone = 2
  srcWaveout = 3
  srcSynthesizer = 4
  srcCompactDisk = 5
  srcTelephone = 6
  srcAuxiliary = 7
  srcDigital = 8
  srcAnalog = 9
End Enum

'Maximum Volume is always 100, Minimum is 0
Const cMaxVol As Integer = 100
Const cMinVol As Integer = 0
Private bPlaySelClick As Boolean 'in order to avoid infinite loop changes
Private bRecSelClick As Boolean



Private Sub Form_Load()
  
  sldMasterVolume.Max = cMaxVol
  sldMasterVolume.Min = cMinVol
  sldRecMasterVolume.Max = cMaxVol
  sldRecMasterVolume.Min = cMinVol

  sldPlayVolume.Max = cMaxVol
  sldPlayVolume.Min = cMinVol
  sldRecVolume.Max = cMaxVol
  sldRecVolume.Min = cMinVol
  
  'Populate combo boxes for Play and Recording Source Type selections
  cboPlaySrcType.AddItem "0 - Undefined"
  cboPlaySrcType.AddItem "1 - Line"
  cboPlaySrcType.AddItem "2 - Mic"
  cboPlaySrcType.AddItem "3 - Wave"
  cboPlaySrcType.AddItem "4 - MIDI"
  cboPlaySrcType.AddItem "5 - CD"
  cboPlaySrcType.AddItem "6 - Phone"
  cboPlaySrcType.AddItem "7 - Aux"
  cboPlaySrcType.AddItem "8 - Digital"
  cboPlaySrcType.AddItem "9 - Analog"
  
  cboRecSrcType.AddItem "0 - Undefined"
  cboRecSrcType.AddItem "1 - Line"
  cboRecSrcType.AddItem "2 - Mic"
  cboRecSrcType.AddItem "3 - Wave"
  cboRecSrcType.AddItem "4 - MIDI"
  cboRecSrcType.AddItem "5 - CD"
  cboRecSrcType.AddItem "6 - Phone"
  cboRecSrcType.AddItem "7 - Aux"
  cboRecSrcType.AddItem "8 - Digital"
  cboRecSrcType.AddItem "9 - Analog"
  
  bPlaySelClick = False
  bRecSelClick = False
  
  'Reflect if Full Duplex supported in a current sound device (Mixer)
  chkFullDuplex.Value = Abs(VRMixer1.FullDuplexSupport)
  
  'Set Volume sliders according to the current settings
  '(for slider control reverse value subtracting from the maximum)
  sldMasterVolume.Value = cMaxVol - VRMixer1.PlayMasterVolume
  sldPlayVolume.Value = cMaxVol - VRMixer1.PlayVolume
  sldRecVolume.Value = cMaxVol - VRMixer1.RecVolume
  
  'Master volume for the Recording line can be present or not
  If VRMixer1.RecMasterVolume <> -1 Then
    sldRecMasterVolume.Value = cMaxVol - VRMixer1.RecMasterVolume
  Else
    sldRecMasterVolume.Value = 0
    sldRecMasterVolume.Enabled = False
  End If
    
  'For Mute checkboxes, check that value isn't -1 (unavailable)
  If VRMixer1.PlayMasterMute <> -1 Then
    chkMasterMute.Value = VRMixer1.PlayMasterMute
  Else
    chkMasterMute.Enabled = False
  End If
  If VRMixer1.RecMasterMute <> -1 Then
    chkRecMasterMute.Value = VRMixer1.RecMasterMute
  Else
    chkRecMasterMute.Enabled = False
  End If
  If VRMixer1.PlayMute <> -1 Then
    chkPlayMute.Value = VRMixer1.PlayMute
  Else
    chkPlayMute.Enabled = False
  End If
    
  'There is often no mute on recording line
  If VRMixer1.RecMute <> -1 Then
    chkRecMute.Value = VRMixer1.RecMute
  Else '-1: Mute is unavailable
    chkRecMute.Value = vbUnchecked
    chkRecMute.Enabled = False
  End If
  
  'Display the current Play Source Type in a combo box, and its name
  cboPlaySrcType.ListIndex = VRMixer1.PlaySourceType 'causes Click event for the combo
  lblPlaybackSource.Caption = VRMixer1.PlaySourceName
  
  'Same for the current Recording Source
  cboRecSrcType.ListIndex = VRMixer1.RecSourceType
  lblRecordingSource.Caption = VRMixer1.RecSourceName
  
  If VRMixer1.PlayPeakmeterValue = -1 Then
    chkPlayPeakmeter.Value = vbUnchecked
    sldPlayMeterInterval.Enabled = False
  Else
    chkPlayPeakmeter.Value = vbChecked
  End If
  
  If VRMixer1.RecPeakmeterValue = -1 Then
    chkRecPeakmeter.Value = vbUnchecked
    sldRecMeterInterval.Enabled = False
  Else
    chkRecPeakmeter.Value = vbChecked
  End If
  
  If VRMixer1.PlayPeakmeterValue = -1 And VRMixer1.RecPeakmeterValue = -1 Then
    'no need to use MCI recording if no Meter is present
    cmdRecord.Enabled = False
  End If
  
  chkRetainValues.Value = Abs(VRMixer1.RetainValues)
  
End Sub


Private Sub cboPlaySrcType_Click()
  
  VRMixer1.PlaySourceType = cboPlaySrcType.ListIndex
  
  'if .PlaySourceType value hasn't changed then selected type is not available
  If VRMixer1.PlaySourceType <> cboPlaySrcType.ListIndex Then
    'restore the current type in a combo
    cboPlaySrcType.ListIndex = VRMixer1.PlaySourceType
    Exit Sub
  End If
  
  lblPlaybackSource.Caption = VRMixer1.PlaySourceName
  sldPlayVolume.Value = cMaxVol - VRMixer1.PlayVolume
  
  'Check if Mute is available on selected Playback line
  If VRMixer1.PlayMute <> -1 Then
    chkPlayMute.Value = VRMixer1.PlayMute
  Else 'Mute is unavailable
    chkPlayMute.Value = vbUnchecked
    chkPlayMute.Enabled = False
  End If

  'If Multiplexer is present then check the current state of selection
  If VRMixer1.PlaySelect = -1 Then
    chkPlaySelect.Value = 1
    chkPlaySelect.Enabled = False
  Else
    chkPlaySelect.Value = VRMixer1.PlaySelect
    chkPlaySelect.Enabled = True
  End If

End Sub

Private Sub cboRecSrcType_Click()
  
  VRMixer1.RecSourceType = cboRecSrcType.ListIndex
  
  'if .PlaySourceType value hasn't changed then selected type is not available
  If VRMixer1.RecSourceType <> cboRecSrcType.ListIndex Then
    'restore the current type in combo
    cboRecSrcType.ListIndex = VRMixer1.RecSourceType
    Exit Sub
  End If
  
  lblRecordingSource.Caption = VRMixer1.RecSourceName
  sldRecVolume.Value = cMaxVol - VRMixer1.RecVolume
  
  'There is often no mute on recording line (if Mux is present)
  If VRMixer1.RecMute <> -1 Then
    chkRecMute.Value = VRMixer1.RecMute
  Else '-1: Mute is unavailable
    chkRecMute.Value = vbUnchecked
    chkRecMute.Enabled = False
  End If
  
  If VRMixer1.RecSelect = -1 Then
    chkRecSelect.Value = 1
    chkRecSelect.Enabled = False
  Else
    chkRecSelect.Value = VRMixer1.RecSelect
    chkRecSelect.Enabled = True
  End If

End Sub

Private Sub chkMasterMute_Click()
  VRMixer1.PlayMasterMute = chkMasterMute.Value
End Sub

Private Sub chkRecMasterMute_Click()
  VRMixer1.RecMasterMute = chkRecMasterMute.Value
End Sub

Private Sub chkPlayMute_Click()
  VRMixer1.PlayMute = chkPlayMute.Value
End Sub

Private Sub chkRecMute_Click()
  VRMixer1.RecMute = chkRecMute.Value
  If chkRecMute.Value <> VRMixer1.RecMute Then chkRecMute.Value = VRMixer1.RecMute
End Sub

Private Sub chkPlaySelect_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  'Notifies if Click event was caused by Mouse Click
  bPlaySelClick = True
End Sub

Private Sub chkPlaySelect_Click()
  If bPlaySelClick Then 'mouse click
    If chkPlaySelect.Value = vbChecked Then
      VRMixer1.PlaySelect = 1
    Else 'don't unselect if clicked by mouse
      chkPlaySelect.Value = vbChecked
    End If
    bPlaySelClick = False
  End If

End Sub

Private Sub chkRecSelect_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  bRecSelClick = True 'click event will know if caused by Mouse Click
End Sub

Private Sub chkRecSelect_Click()
  If bRecSelClick Then 'mouse click
    If chkRecSelect.Value = vbChecked Then
      VRMixer1.RecSelect = 1
    Else 'don't unselect if clicked by mouse
      chkRecSelect.Value = vbChecked
    End If
    bRecSelClick = False
  End If

End Sub

Private Sub chkRetainValues_Click()
  VRMixer1.RetainValues = chkRetainValues.Value
End Sub

Private Sub cmdClose_Click()
  Unload Me
  End
End Sub

Private Sub sldMasterVolume_Scroll()
Dim NewVal As Long
  
  'Reverse slider value as 0 is at the top of a slider control
  NewVal = cMaxVol - sldMasterVolume.Value
  lblCurMasterVolume.Caption = NewVal
  VRMixer1.PlayMasterVolume = NewVal

End Sub

Private Sub sldPlayMeterInterval_Change()
  VRMixer1.PlayPeakmeterInterval = sldPlayMeterInterval.Value
  lblPlayMeterInterval.Caption = VRMixer1.PlayPeakmeterInterval
End Sub


Private Sub sldRecMasterVolume_Scroll()
Dim NewVal As Long
  
  'Reverse slider value as 0 is at the top of a slider control
  NewVal = cMaxVol - sldRecMasterVolume.Value
  lblCurRecMasterVolume.Caption = NewVal
  VRMixer1.RecMasterVolume = NewVal

End Sub

Private Sub sldPlayVolume_Scroll()
Dim NewVal As Long

   NewVal = cMaxVol - sldPlayVolume.Value
   lblCurPlayVolume.Caption = NewVal
   VRMixer1.PlayVolume = NewVal

End Sub

Private Sub sldRecMeterInterval_Change()
  VRMixer1.RecPeakmeterInterval = sldRecMeterInterval.Value
  lblRecMeterInterval.Caption = VRMixer1.RecPeakmeterInterval
  If VRMixer1.RecPeakmeterInterval = 0 Then pbRecPeakmeter.Value = 0
End Sub

Private Sub sldRecVolume_Scroll()
Dim NewVal As Long

  NewVal = cMaxVol - sldRecVolume.Value
  lblCurRecVolume.Caption = NewVal
  VRMixer1.RecVolume = NewVal

End Sub

Private Sub VRMixer1_MixerError(ErrMessage As String, ErrNo As VRMixerOCX.MixerError_ENUM)
  MsgBox ErrMessage, vbExclamation
End Sub

Private Sub VRMixer1_PlayMasterMuteChanged(NewState As Integer)
  chkMasterMute.Value = NewState
End Sub

Private Sub VRMixer1_PlayMasterVolumeChanged(NewVolume As Long)
  'Reversing the value for Slider to display correctly
  sldMasterVolume.Value = cMaxVol - NewVolume
End Sub

Private Sub VRMixer1_PlayPeakmeterChanged(NewVal As Long)
  pbPlayPeakmeter.Value = Abs(NewVal)
End Sub

Private Sub VRMixer1_RecMasterMuteChanged(NewState As Integer)
  chkRecMasterMute.Value = NewState
End Sub

Private Sub VRMixer1_RecMasterVolumeChanged(NewVolume As Long)
  'Reversing the value for Slider to display correctly
  sldRecMasterVolume.Value = cMaxVol - NewVolume
End Sub

Private Sub VRMixer1_PlayMuteChanged(NewState As Integer)
  chkPlayMute.Value = NewState
End Sub

Private Sub VRMixer1_PlaySelChanged(NewState As Integer)
  chkPlaySelect.Value = NewState
  'If chkPlaySelect.Value = vbUnchecked Then chkPlaySelect.Enabled = False
End Sub

Private Sub VRMixer1_PlayVolumeChanged(NewVolume As Long)
  sldPlayVolume.Value = cMaxVol - NewVolume
End Sub

Private Sub VRMixer1_RecMuteChanged(NewState As Integer)
  chkRecMute.Value = NewState
End Sub

Private Sub VRMixer1_RecPeakmeterChanged(NewVal As Long)
  pbRecPeakmeter.Value = Abs(NewVal)
End Sub

Private Sub VRMixer1_RecSelChanged(NewState As Integer)
  chkRecSelect.Value = NewState
  'If chkRecSelect.Value = vbUnchecked Then chkRecSelect.Enabled = False

End Sub

Private Sub VRMixer1_RecVolumeChanged(NewVolume As Long)
  sldRecVolume.Value = cMaxVol - NewVolume
End Sub


Private Sub cmdRecord_Click()
Static bNotFirstTime As Boolean

If LCase(cmdRecord.Caption) = "o" Then

  If bNotFirstTime = False Then
    MsgBox "Please connect Microphone, press OK and start speaking..."
    bNotFirstTime = True
  End If
  
  If VRMixer1.RecPeakmeterValue <> -1 Then 'if PeakMeter present
  'Set Meter readings interval
    sldRecMeterInterval.Value = 50
  End If
  
  'Record from microphone
  cboRecSrcType.ListIndex = srcMicrophone
  'Record for 10 secs then play
  tmrRecord.Interval = 10500 'play in 1/2 sec after recording is done
  tmrRecord.Enabled = True
  cmdRecord.Caption = "|"
  Call WaveRecord(10000) 'record for 10 sec.
    
  cmdPlay.Enabled = True

Else 'already recording
  'Stop Meter readings
  sldRecMeterInterval.Value = 0
  Call WaveStop
  cmdRecord.Caption = "o"
End If

End Sub

Private Sub cmdPlay_Click()
  
If cmdPlay.Caption = ">" Then
  'Stop Rec. Meter readings
  sldRecMeterInterval.Value = 0
  
  If VRMixer1.PlayPeakmeterValue <> -1 Then
  'If Playback PeakMeter present, Set Interval
    sldPlayMeterInterval.Value = 50
  End If

  'Switch Playback to Wave
  cboPlaySrcType.ListIndex = srcWaveout
  tmrRecord.Enabled = False
  cmdPlay.Caption = "|"
  Call WavePlay

Else
  'Stop Meter readings
  sldPlayMeterInterval.Value = 0
  Call WaveStop
  cmdPlay.Caption = ">"
End If

End Sub


Private Sub Form_Unload(Cancel As Integer)
  Call WaveClose
End Sub

Private Sub tmrRecord_Timer()
'use timer to play immediately after recording
  tmrRecord.Enabled = False
  sldRecMeterInterval.Value = 0
  
  cboPlaySrcType.ListIndex = srcWaveout
  Call WavePlay
End Sub

